#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//fractalius colosusMod01.fsh   by   nayk  
//https://www.shadertoy.com/view/XXV3R3
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time iTime
#define resolution iResolution.xy


mat2 rot(float r){
return mat2(cos(r),sin(r),-sin(r),cos(r));
}

vec2 pmod(vec2 p, float n){
float np = 3.1415*2./n;
float r = atan(p.y,p.x)-0.5*np;
r = mod(r,np)-0.5*np;
return length(p)*vec2(cos(r),sin(r));
}


float cube(vec3 p,vec3 s){
vec3 q = abs(p);
vec3 m = max(s-q,0.);
return length(max(q-s,0.))-min(min(m.x,m.y),m.z);
}

float crossBox(vec3 p,float s){
float m1 = cube(p,vec3(s,s,1.));

float m2 = cube(p,vec3(1.,s,s));

float m3 = cube(p,vec3(s,9.,s));

return min(min(m1,m2),m3);
}

float dist(vec3 p){

p.z += time*0.0;
p.y+=2.5;
p.xy = pmod(p.xy,10.);

for(int i  =0;i<5;i++){
p = abs(p)-3.;
p.xy*=rot(time*0.1);
            p.xz*=rot(time*.1);
             p.yz*=rot(time*.1);
}

float k = 0.5;
p = mod(p,k)-0.5*k;
return min(crossBox(p,0.05),cube(p,vec3(0.1)));
}

/* 
a second of time spent in torment, but at the will of a stranger in vain, on strangers many years of torment not in vain! your labors will not be devalued*/
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

vec2 p = ( gl_FragCoord.xy / resolution.xy );
p = (p-0.5)*2.;
p.x *= resolution.x/resolution.y;


p.y*=mod(fragCoord.x,2.);
vec3 ro = vec3(0.,0.0,0.0);
vec3 rd = normalize(vec3(p,0.2)-ro);
;
float d,t=4.;

float ac = 0.;

for(int i = 0;i<10;i++){
d = dist(ro+rd*t);
t += d;
ac += exp(-2.0*d);
if(d<0.01) break;
}

float cl = exp(-1.0*t);

vec3 col = vec3(0.2,0.5,0.2)*0.05*vec3(ac);
col += vec3(0,0.3,0.3);
col = pow(col,vec3(0.7));
if(d<0.01) col +=vec3(0.4,0.8,0.9)*0.01/abs(mod((ro+rd*t).z,1.0)-0.5);
fragColor = vec4(col, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

